% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/verify.R
\name{verify}
\alias{verify}
\title{verify face}
\usage{
verify(image, subject_id, gallery)
}
\arguments{
\item{image}{An image of file type 'JPG', 'PNG', or 'BMP'.
Can either be an url string or a local image processed with \code{\link[facerec]{prep_image}}.}

\item{subject_id}{A string containing the id for the person in the gallery to be verified.}

\item{gallery}{A string containing the name of the gallery in which the subject will be verified.}
}
\value{
A data frame with the verification annotations for the input image. The likelihood of a match is given in column \code{confidence}.
}
\description{
Verify whether face in an input image belongs to a subject in a gallery.
}
\examples{

\donttest{

facerec_init()

# enroll
padme_image <- 'https://upload.wikimedia.org/wikipedia/en/e/ee/Amidala.png'
padme_face <- enroll(image = padme_image, subject_id = 'padme', gallery = 'starwars')

# verify
amidala_img <- 'https://upload.wikimedia.org/wikipedia/it/5/5e/Padm\%C3\%A9_Amidala.png'
verified <- verify(image = amidala_img, subject_id = 'padme', gallery = 'starwars')

}

}
