% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nnetar.R
\name{refit.NNETAR}
\alias{refit.NNETAR}
\title{Refit a NNETAR model}
\usage{
\method{refit}{NNETAR}(object, new_data, specials = NULL, reestimate = FALSE, ...)
}
\arguments{
\item{object}{A model for which forecasts are required.}

\item{new_data}{A tsibble containing the time points and exogenous regressors to produce forecasts for.}

\item{specials}{(passed by \code{\link[fabletools:forecast]{fabletools::forecast.mdl_df()}}).}

\item{reestimate}{If \code{TRUE}, the networks will be initialized with random
starting weights to suit the new data. If \code{FALSE}, for every network the best
individual set of weights found in the pre-estimation process is used as the
starting weight vector.}

\item{...}{Other arguments passed to methods}
}
\value{
A refitted model.
}
\description{
Applies a fitted NNETAR model to a new dataset.
}
\examples{
lung_deaths_male <- as_tsibble(mdeaths)
lung_deaths_female <- as_tsibble(fdeaths)

fit <- lung_deaths_male \%>\%
  model(NNETAR(value))

report(fit)

fit \%>\%
  refit(new_data = lung_deaths_female, reestimate = FALSE) \%>\%
  report()
}
