% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/model.R
\name{glance.fbl_prophet}
\alias{glance.fbl_prophet}
\title{Glance a prophet model}
\usage{
\method{glance}{fbl_prophet}(x, ...)
}
\arguments{
\item{x}{model or other R object to convert to single-row data frame}

\item{...}{other arguments passed to methods}
}
\value{
A one row tibble summarising the model's fit.
}
\description{
A glance of a prophet provides the residual's standard deviation (sigma), and
a tibble containing the selected changepoints with their trend adjustments.
}
\examples{

\donttest{
if (requireNamespace("tsibbledata")) {
library(tsibble)
library(dplyr)
fit <- tsibbledata::aus_production \%>\%
  model(
    prophet = prophet(Beer ~ season("year", 4, type = "multiplicative"))
  )

glance(fit)
}
}

}
