% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fabtCI.R
\name{fabtCI}
\alias{fabtCI}
\title{FAB t-interval}
\usage{
fabtCI(y, psi = c(0, 100, 1, 2), alpha = 0.05)
}
\arguments{
\item{y}{a numeric vector with at least two non-missing values}

\item{psi}{a length-four vector of hyperparameters for the prior}

\item{alpha}{the type I error rate, so 1-alpha is the coverage rate}
}
\description{
Computation of a 1-alpha FAB t-interval
}
\details{
A FAB interval is the "frequentist" interval procedure
that is Bayes optimal: It  minimizes the prior expected
interval width among all interval procedures with 
exact 1-alpha frequentist coverage. This function computes 
the FAB t-interval for the mean of a normal population with an 
unknown variance, given a user-specified prior distribution 
determined by \code{psi}. The prior is that the population mean 
and variance are independently distributed as normal and 
inverse-gamma random variables. 
Referring to the elements of \code{psi}
as mu, t2, s20, nu0, the prior is determined as follows:
\enumerate{
\item mu is the prior expectation of the mean
\item t2 is the prior variance of the  mean
\item the population variance is inverse-gamma(nu0/2,nu0 s20/2)
}
}
\examples{
y<-rnorm(10)
fabtCI(y,c(0,10,1,5)) 
fabtCI(y,c(0,1/10,1,5))
fabtCI(y,c(2,10,1,5))
fabtCI(y,c(0,1/10,1,5)) 

}
\author{
Peter Hoff
}
\keyword{htest}
