% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{which_interval}
\alias{which_interval}
\alias{whichInterval}
\title{From a set of intervals, find which interval values belong to}
\usage{
which_interval(x, Intv)

whichInterval(x, Intv)
}
\arguments{
\item{x}{A vector of numeric values}

\item{Intv}{A two-column matrix or an object of class Intervals}
}
\value{
For each value in x: if x[i] is in the set of intervals, the index of the corresponding
  interval(s), NA if no interval contains x[i]
}
\description{
Returns which interval (if any) each number in a vector belongs to, given a set of
user-defined intervals. Intervals can be specified using either two-column matrices or
\code{\link[intervals:Intervals-class]{Intervals}} objects from the \code{intervals} package.
}
\examples{
start <- c(0, 1, 2)
end <- c(.5, 1.3, 3)
intv <- cbind(start, end) # The 1st interval is 0.0-0.5, 2nd is 1.0-1.3, etc.
which_interval(seq(0, 3, l = 10), intv)
}
\seealso{
\%In\%
}
\author{
Simon Barthelme
}
