eyedata
================

<!-- README.md is generated from README.Rmd. Please edit that file -->

<!-- badges: start -->

[![Travis build
status](https://travis-ci.com/tjebo/eyedata.svg?branch=master)](https://travis-ci.com/tjebo/eyedata)
<!-- badges: end -->

Contains open access ophthalmic data sets, curated for the use in R.

## Installation

Install the development version from <https://github.com/tjebo/eyedata>
with:

``` r
# install.packages("devtools")
devtools::install_github("tjebo/eyedata")
```

### Data sets

`eyedata` contains five anonymized real life data sets from patients
treated in Moorfields Eye Hospital, London, UK. **Kindly reference those
data sets by citing the corresponding publications**.

  - **amd**: (Fu et al. [2020](#ref-fu2)) 12 year data of patients with
    treatment-naive neovascular age-related macular degeneration (AMD)
    who received intravitreal anti-VEGF therapy. [original
    data](https://doi.org/10.5061/dryad.nvx0k6dqg)
  - **amd2**: (Fasler et al. [2019](#ref-fasler)) Eyes with
    treatment-naive neovascular age-related macular degeneration (AMD)
    who received intravitreal anti-VEGF therapy. [original
    data](https://datadryad.org/stash/dataset/doi:10.5061/dryad.97r9289)
  - **amd3**: (Arpa et al. [2020](#ref-arpa)) Eyes with treatment-naive
    neovascular age-related macular degeneration (AMD) who received
    intravitreal anti-VEGF therapy.
  - **dme**: (Kern et al. [2020](#ref-kern)) and (Fu and Keane
    [2020](#ref-fu)) Patients with diabetic macular edema (DME) who
    received intravitreal anti-VEGF therapy. [original
    data](https://doi.org/10.5061/dryad.pzgmsbcfw)
  - **amdoct**: (Moraes et al. [2020](#ref-moraes)) OCT segmentation
    data of patients undergoing treatment for neovascular AMD. [original
    data](https://doi.org/10.5061/dryad.2rbnzs7m4)

<div id="refs" class="references">

<div id="ref-arpa">

Arpa, Cristina, Hagar Khalid, Shruti Chandra, Siegfried Wagner, Katrin
Fasler, Livia Faes, Pakinee Pooprasert, et al. 2020. “Ten-Year Survival
Trends of Neovascular Age-Related Macular Degeneration at First
Presentation.” *British Journal of Ophthalmology*.
<https://doi.org/10.1136/bjophthalmol-2020-317161>.

</div>

<div id="ref-fasler">

Fasler, Katrin, Gabriella Moraes, Siegfried Wagner, Karsten U Kortuem,
Reena Chopra, Livia Faes, Gabriella Preston, et al. 2019. “One- and
Two-Year Visual Outcomes from the Moorfields Age-Related Macular
Degeneration Database: A Retrospective Cohort Study and an Open Science
Resource.” *BMJ Open* 9 (6).
<https://doi.org/10.1136/bmjopen-2018-027441>.

</div>

<div id="ref-fu">

Fu, Dun Jack, and Pearse Keane. 2020. *Anti-Vegf Therapy in Diabetic
Macular Oedema Patients over Four Years*. Dryad.
<https://doi.org/10.5061/dryad.pzgmsbcfw>.

</div>

<div id="ref-fu2">

Fu, Dun Jack, Tiarnan D. Keenan, Livia Faes, Ernest Lim, Siegfried K.
Wagner, Gabriella Moraes, Josef Huemer, et al. 2020. “Insights From
Survival Analyses During 12 Years of Anti–Vascular Endothelial Growth
Factor Therapy for Neovascular Age-Related Macular Degeneration.” *JAMA
Ophthalmology*, November.
<https://doi.org/10.1001/jamaophthalmol.2020.5044>.

</div>

<div id="ref-kern">

Kern, Christoph, Dun Jack Fu, Josef Huemer, Livia Faes, Siegfried K.
Wagner, Karsten Kortuem, Praveen J. Patel, et al. 2020. “An Open-Source
Data Set of Anti-VEGF Therapy in Diabetic Macular Oedema Patients over 4
Years and Their Visual Acuity Outcomes.” *Eye*, June.
<https://doi.org/10.1038/s41433-020-1048-0>.

</div>

<div id="ref-moraes">

Moraes, Gabriella, Dun Jack Fu, Marc Wilson, Hagar Khalid, Siegfried K.
Wagner, Edward Korot, Daniel Ferraz, et al. 2020. “Quantitative Analysis
of Optical Coherence Tomography for Neovascular Age-Related Macular
Degeneration Using Deep Learning.” *Ophthalmology*.
<https://doi.org/https://doi.org/10.1016/j.ophtha.2020.09.025>.

</div>

</div>
