% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/checkVA.R
\name{plausibility_methods}
\alias{plausibility_methods}
\alias{checkVA}
\alias{checkVA.quali}
\alias{checkVA.snellen}
\alias{checkVA.snellendec}
\alias{checkVA.logmar}
\alias{checkVA.etdrs}
\alias{checkVA.default}
\title{Plausibility checking}
\usage{
checkVA(x, ...)

\method{checkVA}{quali}(x, ...)

\method{checkVA}{snellen}(x, ...)

\method{checkVA}{snellendec}(x, ...)

\method{checkVA}{logmar}(x, ...)

\method{checkVA}{etdrs}(x, ...)

\method{checkVA}{default}(x, ...)
}
\arguments{
\item{x}{vector of visual acuities}

\item{...}{further arguments passed to methods}
}
\value{
vector with visual acuity of class \code{va}. See also "VA classes"
}
\description{
S3 methods for checking plausibility of VA entries
}
\section{Plausibility checks}{

VA can be snellen (fraction: feet/meter), snellen decimal, logMAR, ETDRS, or
"qualitative" (Counting fingers, etc.)
\itemize{
\item Snellen fractions need to be either form 6/x or 20/x
\item Snellen decimal must be > 0 and <= 2
\item ETDRS must be >= 0 and <= 100
\item logMAR must be >= -0.3 and <= 3.0
\item Qualitative must be PL, LP, NLP, NPL, HM, CF (any case allowed)
}

Any element which is implausible / not recognized will be converted to NA
}

\seealso{
Other VA converter: 
\code{\link{VAwrapper}},
\code{\link{snellen_steps}},
\code{\link{va}()},
\code{\link{va_methods}},
\code{\link{va_mixed}()},
\code{\link{which_va}()}
}
\concept{VA converter}
\keyword{internal}
