% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/expandFunctions.R
\name{eOuter}
\alias{eOuter}
\title{Extend outer product.}
\usage{
eOuter(x, y, FUN, ...)
}
\arguments{
\item{x}{Vector, with the same function as
in outer \{base\}.  Each value will
correspond to a row in the return matrix.}

\item{y}{Vector.  Each
element in the vector corresponds
to a column in the return matrix.}

\item{FUN}{Function. x and y will
be the first and second arguments.  Unlike
\code{outer}, however, while a vector can be the
first argument, FUN might only allow
 \emph{one value} as the
second argument.  This means eOuter
can use lagshift, for instance, as FUN.}

\item{...}{Additional parameters for FUN.}
}
\value{
A matrix \code{Z} of size
\code{length(x) X length(y)}
containing \code{Z[,i]} with values \code{FUN(x,y[i],\dots)}.
}
\description{
Extends outer \{base\} \code{outer(x,y,FUN)} to include functions
\code{FUN(x,y,\dots)} where the first argument of \code{FUN}
is a vector but the second argument must be a scalar.
}
\details{
outer has limitations; it only works with functions which
can take vector inputs for \emph{both}
the first and second arguments, such as "^".  As a result,
many functions cannot be used for FUN.  The function eOuter
gets around this limitation by additionally allowing functions
which accept a vector for the first argument, but only scalars
for the second argument.  It can be used everywhere
that \code{outer} can be used, but also when FUN is
limited in this way.
}
\examples{
# This implements a function similar to ePow
# FIXME: change ePow to use eOuter!!!
eOuter(1:6,0:2,FUN = `^`)
# Other functions of columns
eOuter(1:10,0:3,FUN = lagshift,lagMax=3,pad=NA)
# FIXME: Make function to allow polynomials to be used:
# eOuter(1:10,1:3,FUN = glaguerre.polynomials, alpha=0.5)
}
\seealso{
\code{\link{outer}} and \code{\link{ePow}}
}

