% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/expandFunctions.R
\name{eDiff}
\alias{eDiff}
\title{Matrix size-preserving diff function}
\usage{
eDiff(X, pad = NA)
}
\arguments{
\item{X}{R object coercible to matrix}

\item{pad}{Pad the first row with this value;
the default is NA. 0 would be another value often
used in signal processing.}
}
\value{
Returns a matrix, the same size as the
        input matrix X, containing the back difference by column.
        The first row is filled with copies of pad.
}
\description{
Returns a matrix, the same size as the
input matrix X, containing the back difference.
}
\examples{
eDiff( 1:8 )
eDiff( as.data.frame(1:8) )
eDiff( matrix(1:8,ncol=2) )
}

