% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/all_rawscores.R
\name{all_rawscores}
\alias{all_rawscores}
\title{checks if all possible raw scores occur in the data.}
\usage{
all_rawscores(
  items = NULL,
  dset = NULL,
  na.rm = TRUE,
  model = NULL,
  p.par = NULL,
  modelType = NULL,
  estimation_param = NULL
)
}
\arguments{
\item{items}{a numeric vector containing the index numbers of the items in
dset that are used to fit the model}

\item{dset}{a data.frame containing the data}

\item{na.rm}{a boolean value. If TRUE, all cases with any NA are removed
(na.omit). If FALSE, only cases with full NA responses are removed}

\item{model}{on object of a fit Rasch model, estimated with the packages
'eRm' (classes 'RM', 'PCM' or 'RSM'), 'psychotools' (classes raschmodel,
'pcmodel' or 'rsmodel') or 'pairwise' (class 'pers'), matching the value of
 modelType. If 'model' is provided, this model is used. If NULL, a model is
 fit using 'dset' and 'items'.}

\item{p.par}{a person parameter object matching the class of 'model'. If
NULL, the person parameters will be estimated.}

\item{modelType}{a character value defining the rasch model to fit.
Possible values: "RM", "PCM", "RSM".}

\item{estimation_param}{options for parameter estimation using
\link{estimation_control}}
}
\value{
if all possible raw scores occur in dset, a list containing
 3 elements is returned: the item combination that was tested, a list of
 the class the model was estimated with (depending on modelType and
 estimation_param$est) with the fit model and a list with a person
 parameter object (depending on estimation_param$est).  If at least one
 raw score does not occur in dset, NULL is returned.
}
\description{
checks if all possible raw scores occur in the data.
}
\keyword{internal}
