% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sqrtnp.R
\name{sqrtnp}
\alias{sqrtnp}
\title{Calculating Square Roots of n\emph{p}(1-p) Combinations}
\usage{
sqrtnp(n, p, digits = 2, tol = 10^(-digits - 4))
}
\arguments{
\item{n}{numeric: vector of observations numbers}

\item{p}{numeric: vector of probabilities}

\item{digits}{numeric: number of digits to check (default: \code{2})}

\item{tol}{numeric: tolerance (default: \code{10^(-digits-4)})}
}
\value{
A data frame with the columns \code{n}, \code{p}, \code{np} (\eqn{=np}) and \code{snp} (\eqn{=sqrt(np(1-p))}).
}
\description{
Computes \code{sqrt(n*p*(1-p))} for all combinations of \code{n} and \code{p}.
If the result has only \code{digits} after the decimal point, then \code{n}, \code{p},
and \code{sqrt(n*p*(1-p))} are returned in a data frame.
}
\details{
If \code{abs(v-round(v, digits))<tol} then a number \code{v} is considered as a number
with only \code{digits} after the decimal point.
}
\examples{
n <- 30:250
p <- (10:40)/100
sqrtnp(n, p)
}
