% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/binom_param.R
\name{binom_param}
\alias{binom_param}
\title{Generate Valid Binomial Parameters}
\usage{
binom_param(n, p, mean = NA, sd = NA, norm = NA, pois = NA, tol = 1e-06)
}
\arguments{
\item{n}{integer vector of trial counts}

\item{p}{numeric vector of probabilities}

\item{mean}{numeric or integer specifying required mean digits or specific mean values}

\item{sd}{numeric or integer specifying required standard deviation digits or specific sd values}

\item{norm}{logical, \code{NA}, or function: restricts combinations to those valid for normal approximation}

\item{pois}{logical, \code{NA}, or function: restricts combinations to those valid for Poisson approximation}

\item{tol}{numeric: tolerance for numerical comparisons (default: \code{1e-6})}
}
\value{
A data frame with columns \code{n}, \code{p}, \code{mean}, and \code{sd} representing valid parameter combinations.
}
\description{
Creates a data frame of possible combinations of \code{n} (number of trials)
and \code{p} (probabilities) that satisfy specified constraints on the mean, standard deviation,
and approximation conditions for normal or Poisson distributions.

The function applies the following rules:
\itemize{
\item If \code{length(mean) == 1} and it is an integer, it specifies the number of digits
to which the mean should be rounded.
\item If \code{mean = NA} (default), all mean values are allowed.
\item If \code{length(mean) > 1}, only combinations where \code{n * p} equals one of the specified means are retained.
\item The same logic applies to \code{sd} for the standard deviation.
}

The \code{norm} and \code{pois} arguments can be logical, \code{NA}, or a custom function of the form \verb{function(n, p)}.
They control which \verb{(n, p)} pairs are considered valid:
\itemize{
\item \code{NA} allows all combinations.
\item A function returns \code{TRUE} for valid combinations and \code{FALSE} for invalid ones.
\item \code{TRUE} enforces standard approximation rules:
\itemize{
\item \code{norm}: \code{n * p * (1 - p) > 9} (normal approximation condition)
\item \code{pois}: \code{n > 10 & p < 0.05} (Poisson approximation condition)
}
\item \code{FALSE} excludes combinations that meet the approximation condition.
}

Note: The resulting data frame may be empty if no combinations meet all criteria.
}
\examples{
binom_param(1000:50000, (5:25)/100, mean = 0, sd = 0)
}
