% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/reg_bootstrap.R
\name{plot.regboot}
\alias{plot.regboot}
\title{Plot Method for 'regboot' Class}
\usage{
\method{plot}{regboot}(x, title = "Regular Bootstrap Distribution", ...)
}
\arguments{
\item{x}{An object of class 'regboot', usually the output of the \code{\link{reg_bootstrap}} function.}

\item{title}{A plot title. Default is "Regular Bootstrap Distribution".}

\item{...}{Additional parameters (currently ignored).}
}
\value{
A ggplot object showing the density estimates of the bootstrap sample statistic.
}
\description{
Creates a plot of the density estimates of the bootstrap sample statistics
returned from the \code{\link{reg_bootstrap}} function.
}
\examples{
set.seed(123)
data <- rnorm(5)
result <- reg_bootstrap(data)
plot(result)
}
\seealso{
\code{\link{reg_bootstrap}}, \code{\link{summary.regboot}}
}
