% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/methods_confint_return_level.R
\name{confint_return_level_methods}
\alias{confint_return_level_methods}
\alias{print.confint_return_level}
\alias{plot.confint_return_level}
\title{Methods for objects of class \code{"confint_return_level"}}
\usage{
\method{print}{confint_return_level}(x, ...)

\method{plot}{confint_return_level}(x, parm = 1, add = TRUE, digits = 2, ...)
}
\arguments{
\item{x}{An object inheriting from class \code{"confint_return_level"}, a result
of a call to \code{\link{confint.return_level}}.}

\item{...}{Further arguments. For \code{print.confint_return_level} to pass
arguments to \code{\link{print}}). For \code{plot.confint_return_level} to pass graphical
parameters to \code{\link[graphics:plot.default]{plot}} to create the initial plot of the
profile log-likelihood.}

\item{parm}{An integer scalar. For which component, that is, which return
level, in \code{x} we require a confidence interval.}

\item{add}{A logical scalar. If \code{add = TRUE} then the plot is annotated with
a horizontal line indicating the critical value for the profile
log-likelihood used to calculate the confidence limits, vertical lines
indicating the values of these limits and a legend stating the
confidence interval.}

\item{digits}{An integer. Passed to \code{\link{signif}} to round the confidence
limits in the legend, if \code{add = TRUE}.}
}
\value{
\code{print.confint_return_level}: the argument \code{x} is returned, invisibly.

\code{plot.confint_return_level}: a numeric vector containing the confidence
interval for the return level chosen for the plot.
}
\description{
Methods for objects of class \code{"confint_return_level"} returned from
\code{\link{confint.return_level}}.
}
\details{
\code{print.confint_return_level}. A numeric matrix with 2 columns
giving the lower and upper confidence limits for the parameters specified
by the argument \code{parm} in \code{\link{confint.return_level}}. These columns are
labelled as \code{(1-level)/2} and \code{1-(1-level)/2}, expressed as a percentage,
by default \verb{2.5\%} and \verb{97.5\%}.

\code{plot.confint.return_level}. A plot is produced of the profile log-likelihood for
the parameter chosen by \code{parm}.
}
\section{Examples}{
 See \code{\link{return_level_methods}}.
}

\seealso{
\code{\link{gev_mle}}, \code{\link{gev_return}} and \code{\link{return_level_methods}}.
}
