% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/percent_is_operator.R
\name{\%is\%}
\alias{\%is\%}
\title{Strict identity comparison with diagnostics}
\usage{
a \%is\% b
}
\arguments{
\item{a}{First object (vector, matrix, or data.frame)}

\item{b}{Second object (vector, matrix, or data.frame)}
}
\value{
TRUE if identical, FALSE otherwise (with diagnostics)
}
\description{
A semantic operator that checks whether two objects are strictly identical,
and prints where they differ if not.
}
\examples{
1:3 \%is\% 1:3                  # TRUE
1:3 \%is\% c(1, 2, 3)           # FALSE, type mismatch (integer vs double)
data.frame(x=1) \%is\% data.frame(y=1)  # FALSE, column name mismatch
m1 <- matrix(1:4, nrow=2)
m2 <- matrix(c(1,99,3,4), nrow=2)
m1 \%is\% m2                  # FALSE, value differs at [1,2]
c(a=1, b=2) \%is\% c(b=2, a=1) # FALSE, names differ
}
