% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/daily.R
\name{daily}
\alias{daily}
\title{Calculate daily mean, min or max}
\usage{
daily(
  data,
  time = "date",
  var,
  stat = mean,
  min_offset = 0,
  hour_offset = 0,
  numerical = TRUE,
  verbose = TRUE
)
}
\arguments{
\item{data}{data.frame with time column and variable columns to be processed}

\item{time}{name of the time column (default is date) in POSIXct}

\item{var}{name of the columns to be calculated}

\item{stat}{function of the statistics to calculate (default is mean)}

\item{min_offset}{minutes of observation from previous hour (default is 0)}

\item{hour_offset}{hours of observation from previous day (default is 0)}

\item{numerical}{TRUE (default) include only numerical columns}

\item{verbose}{display additional information}
}
\value{
data.frame with time and the daily mean, min or max
}
\description{
function to calculate daily mean, min or max of a data.frame
}
\examples{
# in case there is connection issue
load_data <- function(cond) {
  message(paste("conection issue, loading pre-downloaded data"))
  DATA <- readRDS(paste0(system.file("extdata",package="eva3dm"),
                         "/riem_OAKB_jan_2012.Rds"))
  return(DATA)
}

sites <- c("OAKB")
for(site in sites){
  cat('Trying to download METAR from:',site,'...\n')
  DATA <- tryCatch(riem::riem_measures(station    = sites,
                                       date_start = "2012-01-01",
                                       date_end   = "2012-02-01"),
                   error = load_data)
}
data_daily_mean <- daily(DATA,time = 'valid')
data_daily_min  <- daily(DATA[1:7],time = 'valid',stat = min)
data_daily_max  <- daily(DATA[1:7],time = 'valid',stat = max)

}
