% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get-team-stats.R
\name{getTeamStats}
\alias{getTeamStats}
\title{Get team statistics}
\usage{
getTeamStats(season_code, team_code, phase_type = "All")
}
\arguments{
\item{season_code}{One or more season codes as obtained from \code{\link[=getCompetitionHistory]{getCompetitionHistory()}}.\cr
Examples are \code{E2023} for Euroleague or \code{U2023} for Eurocup 2023.}

\item{team_code}{One or more team codes as obtained from \code{\link[=getCompetitionTeams]{getCompetitionTeams()}}.\cr
Examples are \code{ASV}, \code{MAD}, ...}

\item{phase_type}{One or more phase type codes as obtained from \code{\link[=getCompetitionPhases]{getCompetitionPhases()}}.\cr
Admitted values are \code{RS} for regular season, \code{PO} for playoffs and \code{FF} for final four.
Default is \code{All} for all.}
}
\value{
Returns a list of elements for the chosen teams and seasons:
\itemize{
\item \strong{PlayerAccumulated}. Total sum of statistics by player
\item \strong{PlayerAveragePerGame}. Average per game of statistics by player
\item \strong{PlayerAveragePer40}. Average per 40 minutes of statistics by player
\item \strong{TeamAccumulated}. Total sum of statistics of team
\item \strong{TeamAveragePerGame}. Average per game of statistics of teams
}

Glossary of columns:\tabular{ll}{
   \strong{Column name} \tab \strong{Column extended name} \cr
   GP \tab Game player \cr
   GS \tab Game started \cr
   MIN \tab Minutes played \cr
   PTS \tab Points scored \cr
   2PM \tab Two-pointers made \cr
   2PA \tab Two-pointers attempted \cr
   2P\% \tab Two-point \% \cr
   3PM \tab Three-pointers made \cr
   3PA \tab Three-pointers attempted \cr
   3FG\% \tab Three-point \% \cr
   FTM \tab Free throws made \cr
   FTA \tab Free throws attempted \cr
   FT\% \tab Free-throw \% \cr
   OREB \tab Offensive rebounds \cr
   DREB \tab Defensive rebounds \cr
   TREB \tab Total rebounds \cr
   AST \tab Assists \cr
   STL \tab Steals \cr
   TO \tab Turnovers \cr
   BLK \tab Blocks \cr
   BLKA \tab Blocks against \cr
   FC \tab Personal fouls committed \cr
   FD \tab Personal fouls drawn \cr
   PIR \tab Performance Index Rating \cr
}


Reference webpage: \href{https://www.euroleaguebasketball.net/euroleague/teams/ldlc-asvel-villeurbanne/statistics/asv/?season=2023-24&phase=All\%20phases}{Team}
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#experimental}{\figure{lifecycle-experimental.svg}{options: alt='[Experimental]'}}}{\strong{[Experimental]}}
}
\examples{

\dontrun{

  TeamStats = getTeamStats(team_code = "ASV", season_code = c("E2023", "E2022"), phase_type = "RS")

  TeamStats$PlayerAccumulated |> head(5)

  TeamStats$PlayerAveragePerGame |> head(5)

  TeamStats$PlayerAveragePer40 |> head(5)

  TeamStats$TeamAccumulated |> head(5)

  TeamStats$TeamAveragePerGame |> head(5)

}

}
