% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get-team-lead-stats.R
\name{getTeamLeadStats}
\alias{getTeamLeadStats}
\title{Get team lead statistics}
\usage{
getTeamLeadStats(season_code, phase_type = "All", subset = "All")
}
\arguments{
\item{season_code}{One or more season codes as obtained from \code{\link[=getCompetitionHistory]{getCompetitionHistory()}}.\cr
Examples are \code{E2023} for Euroleague or \code{U2023} for Eurocup 2023.}

\item{phase_type}{One or more phase type codes as obtained from \code{\link[=getCompetitionPhases]{getCompetitionPhases()}}.\cr
Admitted values are \code{RS} for regular season, \code{PO} for playoffs and \code{FF} for final four.
Default is \code{All} for all.}

\item{subset}{One or more game subsets.\cr
Admitted values are \code{HomeGames}, \code{AwayGames}, \code{GamesWon}, \code{GamesLost},
\code{ResultsIn5Points} (for games resulted in +/-5 points) and \code{All}.
Default is \code{All}.}
}
\value{
Returns a list of elements for the chosen seasons, phase_type and subset.
\itemize{
\item \strong{TeamAccumulated}. Total sum of statistics of all teams team
\item \strong{TeamAveragePerGame}. Average per game of statistics of all teams
}

Glossary of columns:\tabular{ll}{
   \strong{Column name} \tab \strong{Column extended name} \cr
   GP \tab Game player \cr
   GS \tab Game started \cr
   MIN \tab Minutes played \cr
   PTS \tab Points scored \cr
   2PM \tab Two-pointers made \cr
   2PA \tab Two-pointers attempted \cr
   2P\% \tab Two-point \% \cr
   3PM \tab Three-pointers made \cr
   3PA \tab Three-pointers attempted \cr
   3P\% \tab Three-point \% \cr
   FTM \tab Free throws made \cr
   FTA \tab Free throws attempted \cr
   FT\% \tab Free-throw \% \cr
   OREB \tab Offensive rebounds \cr
   DREB \tab Defensive rebounds \cr
   TREB \tab Total rebounds \cr
   AST \tab Assists \cr
   STL \tab Steals \cr
   TO \tab Turnovers \cr
   BLK \tab Blocks \cr
   BLKA \tab Blocks against \cr
   FC \tab Personal fouls committed \cr
   FD \tab Personal fouls drawn \cr
   PIR \tab Performance Index Rating \cr
}


Reference webpage: \href{https://www.euroleaguebasketball.net/euroleague/stats/key-stats-teams/?size=200&misc=HomeGames&seasonCode=E2023&category=FreeThrowsAttempted&seasonMode=Single&sortDirection=descending&aggregate=accumulated}{TeamLead}
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#experimental}{\figure{lifecycle-experimental.svg}{options: alt='[Experimental]'}}}{\strong{[Experimental]}}
}
\examples{

\dontrun{

  TeamLeadStats = getTeamLeadStats(season_code = c("E2022", "E2023"), phase_type = "RS")

  TeamLeadStats$TeamAccumulated |> head(5)

  TeamLeadStats$TeamAveragePerGame |> head(5)

}

}
