% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/esem_cfa2.R
\name{esem_cfa2}
\alias{esem_cfa2}
\title{Exploratory Structural Equiation Modeling ESEM (ESEM) with geominT rotation}
\usage{
esem_cfa2(
  data,
  nfactors,
  fm = "ML",
  rotate = "geominT",
  scores = "regression",
  residuals = TRUE,
  Target = NULL,
  missing = TRUE,
  mimic = c("MPlus"),
  std.lv = TRUE,
  ordered = TRUE
)
}
\arguments{
\item{data}{is a raw data matrix.}

\item{nfactors}{is number of factors to extract}

\item{fm}{is factoring method to be used in factor estimation. The suggested methods are available in  \cite{psych::fa()}}

\item{rotate}{is the rotation method to be used. The suggested methods are available in  \cite{psych::fa()}}

\item{scores}{is the factor scores to be used in EFA estimation. The default scores are estimated using regression as set in "regression".}

\item{residuals}{is set to FALSE by default. In case the residual matrix is required in the output, this parameter should be set to TRUE}

\item{Target}{is the target rotation matrix to be used. In case no target matrix is provided, EFA proceeds with alternative approach. The list of target rotations are available from \cite{GPArotation}}

\item{missing}{is used with scores set to TRUE. The default is missing=TRUE which imputes missing values using either the median or the mean.}

\item{mimic}{allows to mimic the final output results (i.e. CFA stage) to MPLUS to allow the user to compare the output.}

\item{std.lv}{is set to TRUE by default to provide standardized latent variables.}

\item{ordered}{is set to TRUE by default to allow the use of categorical variables.}
}
\value{
An object of class \cite{lavaan::lavaan-class}, for which several methods are available, including a summary method.
}
\description{
Exploratory Structural Equiation Modeling ESEM (ESEM) with geominT rotation
}
