% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_event.R
\name{plot_event}
\alias{plot_event}
\title{Create a comprehensive multi panel plot of a seismic waveform}
\usage{
plot_event(data, ratio = c(0.3, 0.3), ...)
}
\arguments{
\item{data}{\code{eseis} object, or \code{numeric} vector, data 
set to be plotted.}

\item{ratio}{\code{Numeric} vector of length two, ratios of the plot 
panels, i.e. in horizonal and vertical direction. Default is 
\code{c(0.3, 0.3)}.}

\item{\dots}{Additional arguments passed to the plot function. See 
details for further information}
}
\value{
Graphic output of an event waveform.
}
\description{
The function creates from an input waveform a multi panel plot, 
including a seismogram, spectrum and spectrogram, and additional 
frequency statistics information.
}
\details{
Note that plot generation time can get long when other than short 
events are passed to the function. The axes limits can only be changed 
for the spectrum and spectrogram plots, \code{ylim} affects the frequency
range, \code{zlim} affects the spectral power range.

The function uses the native plot function \code{plot_signal()},
\code{plot_spectrum()} and \code{plot_spectrogram()} along with 
\code{signal_stats()} to build a four panel plot.
}
\examples{

\dontrun{

## load and deconvolve example event
data(rockfall)
rockfall_eseis <- signal_deconvolve(rockfall_eseis)

## plot event straight away
plot_event(data = rockfall_eseis)

## plot event with adjusted parameters
plot_event(data = rockfall_eseis, 
           ratio = c(0.4, 0.3),
           method = "periodogram",
           n = 100, 
           window = 6,
           overlap = 0.8, 
           window_sub = 4, 
           overlap_sub = 0.8,
           format ="\%M:\%S", 
           col = "jet",
           ylim = c(5, 80),
           zlim = c(-170, -100))
}

}
\author{
Michael Dietze
}
\keyword{eseis}
