% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/select_dose_by_cibp.R
\name{select_dose_by_cibp}
\alias{select_dose_by_cibp}
\title{Select dose by the CIBP selection criterion.}
\usage{
select_dose_by_cibp(parent_selector_factory, a, target = NULL)
}
\arguments{
\item{parent_selector_factory}{Object of type \code{\link{selector_factory}}.}

\item{a}{Number between 0 and 2, the asymmetry parameter. See References.}

\item{target}{We seek a dose with this probability of toxicity. If not
provided, the value will be sought from the parent dose-selector.}
}
\value{
an object of type \code{\link{selector_factory}} that can fit a
dose-finding model to outcomes.
}
\description{
This method selects dose by the convex infinite bounds penalisation (CIBP)
criterion of Mozgunov & Jaki. Their method is mindful of the uncertainty in
the estimates of the probability of toxicity and uses an asymmetry parameter
to penalise escalation to risky doses.
}
\examples{
skeleton <- c(0.05, 0.1, 0.25, 0.4, 0.6)
target <- 0.33

# Let's compare escalation behaviour of a CRM model without CIBP criterion:
model1 <- get_dfcrm(skeleton = skeleton, target = target)
# To one with the CIBP criterion:
model2 <- get_dfcrm(skeleton = skeleton, target = target) \%>\%
  select_dose_by_cibp(a = 0.3)

# Despite one-in-three tox at first dose, regular model is ready to escalate:
model1 \%>\% fit('1NTN') \%>\% recommended_dose()
# But the model using CIBP is more risk averse:
model2 \%>\% fit('1NTN') \%>\% recommended_dose()

}
\references{
Mozgunov P, Jaki T. Improving safety of the continual reassessment method via
a modified allocation rule. Statistics in Medicine.1-17. doi:10.1002/sim.8450
}
