% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/backtest_functions.R
\name{er_backtest}
\alias{er_backtest}
\title{Exceedance Residuals Backtest}
\usage{
er_backtest(r, q, e, s = NULL, B = 1000)
}
\arguments{
\item{r}{A vector of returns.}

\item{q}{A vector of Value-at-Risk forecasts.}

\item{e}{A vector of Expected Shortfall forecasts.}

\item{s}{A vector of volatility forecasts.}

\item{B}{Number of bootstrap iterations}
}
\value{
Returns a list with the following components:
\itemize{
\item pvalue_twosided_simple
\item pvalue_onesided_simple
\item pvalue_twosided_standardized
\item pvalue_onesided_standardized
}
}
\description{
Tests whether the mean of the exceedance residuals, respectively the
mean of the standardized exceedance residuals is zero.
}
\examples{
data(risk_forecasts)
r <- risk_forecasts$r
q <- risk_forecasts$q
e <- risk_forecasts$e
s <- risk_forecasts$s
er_backtest(r = r, q = q, e = e, s = s)
}
\references{
McNeil & Frey (2000) \doi{10.1016/S0927-5398(00)00012-8}
}
