% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/esDesign.R
\name{AED.sim}
\alias{AED.sim}
\title{Conduct the simulation studies of the Adaptive Enrichment Design without
  early stopping boundary}
\usage{
AED.sim(
  N1,
  N2,
  rho,
  alpha,
  beta,
  theta,
  theta0,
  K,
  Info,
  epsilon,
  sigma0,
  nSim,
  Seed
)
}
\arguments{
\item{N1}{The sample size used at the first stage}

\item{N2}{The sample size used at the second stage}

\item{rho}{The proportion of the subgroup 1}

\item{alpha}{The overall Type I error rate}

\item{beta}{The (1 - Power)}

\item{theta}{The sizes of treatment effects in subgroups 1 and 2 among the
experimental arm}

\item{theta0}{The size of treatment effect in standard arm}

\item{K}{The number of subgroups}

\item{Info}{The observed information}

\item{epsilon}{The threshold of difference between the subgroup-specific test
statistics}

\item{sigma0}{The variance of the treatment effect}

\item{nSim}{The number of simulated studies}

\item{Seed}{The random Seed}
}
\value{
A list contains
\itemize{
  \item nTotal The average expected sample size
  \item H00 The probability of rejecting the null hypothesis of \eqn{H_{00}}
  \item H01 The probability of rejecting the null hypothesis of \eqn{H_{01}}
  \item H02 The probability of rejecting the null hypothesis of \eqn{H_{02}}
  \item H0  The probabilities of rejecting at least one of the null hypothesis
  \item Enrich01 The prevalence of adaptive enrichment of subgroup 1
  \item Enrich02 The prevalence of adaptive enrichment of subgroup 2
}
}
\description{
The \code{AED.sim()} is used to conduct the simulation studies
   of the Adaptive Enrichment Design without early stopping boundary. The AED
   design is quite similar with the AED1_SSR design. But, in the AED design,
   the futility stopping boundary and the Sample Size Re-estimation Procedure
   are removed. On the contrary, a fixed sample size is used to replace the
   sample size re-estimated procedure. In addition, an \eqn{\epsilon}-rule is
   also introduced to select the subgroup with larger subgroup-specific test
   statistic.
}
\examples{
N1 <- 310
N2 <- 310
rho <- 0.5
alpha <- 0.05
beta <- 0.20
theta <- c(0,0)
theta0 <- 0
K <- 2
Info <- 0.5
epsilon <- 0.5
sigma0 <- 1
nSim <- 1000
Seed <- 6
AED.sim(N1 = N1, N2 = N2, rho = rho, alpha = alpha,
        beta = beta, theta = theta, theta0 = theta0,
        K  = K, Info = Info, epsilon = epsilon,
        sigma0 = sigma0, nSim = nSim, Seed = Seed)
}
\references{
\itemize{
  \item Lin, R., Yang, Z., Yuan, Y. and Yin, G., 2021. Sample size re-estimation
   in adaptive enrichment design. Contemporary Clinical Trials, 100, p.106216.
   <doi: 10.1016/j.cct.2020.106216>
}
}
