% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/GrandavgPlot.R
\name{grandaverage}
\alias{grandaverage}
\title{Plot the grand average waveform for all loaded conditions}
\usage{
grandaverage(data, electrodes, window = NULL, lgnd = NULL)
}
\arguments{
\item{data}{A data frame in the format returned from \code{\link{load.data}}}

\item{electrodes}{A single value or concatenation of several values (to be averaged)
indicating which electrodes to include in generating the plot. At this time, if the
raw data files imported using \code{\link{load.data}}) do not have a header, you
must include a capital "V" in front of the number and enclose each electrode in quotes.
(For example, electrodes = "V78", or electrodes = c("V78", "V76").)}

\item{window}{The beginning and end points of a time window of interest; this is different
from the beginning and ending times \code{epoch.st} and \code{epoch.end} defined in
\code{\link{load.data}} (you only need to define the epoch once upon importing the data).
The purpose of the \code{window} argument in this function is merely to highlight a
window of interest; its default value is NULL.}

\item{lgnd}{Whether or not a legend should appear on the plot. By default a legend
will appear, but can be suppressed by setting \code{lgnd} equal to "n".}
}
\value{
A single plot of grand average waveforms for each condition. Includes a
  color-coded and labeled legend (that can be suppressed if specified). Also
  returns the raw waveform data for each condition.
}
\description{
\code{grandaverage} plots the grand average waveform for each condition present in the
  data frame you provide.  A color-coded and labeled legend is generated with the plot
  for ease of identification of each condition.  The legend can be suppressed if it
  interferes with the data presentation (i.e., hides part of the waveform).
}
\details{
\code{grandaverage} will return a plot of the grand average waveform for each
  condition present in the data frame you provide.  For ease of use, colors are
  automatically assigned. The legend displays the value provided in the \code{condition}
  argument of \code{\link{load.data}}.

  Single electrodes can be passed to the package functions, or several electrodes
  can be provided (i.e., when using dense arrays) and those electrodes will be
  averaged together as a single electrode.
}
\examples{
# Create a plot of the grand average waveforms for each imported condition
grandaverage(ERPdata, electrodes = "V78", window = c(1000, 1500))

}
\author{
Travis Moore
}
