% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bechdel.R
\docType{data}
\name{bechdel}
\alias{bechdel}
\title{Top 10 Highest-Rated, Bechdel-Passing Movies}
\format{
A data frame with 10 rows and 18 variables:
\describe{
\item{imdb_id}{IMDB Movie ID}
\item{bechdel_rating}{Rating (0-3): 0 = unscored; 1 = It has to have at least two (named) women in it; 2 = Who talk to each other; 3 = About something besides a man.}
\item{year}{Year}
\item{title}{Title of movie}
\item{budget}{Budget in $USD as of release year}
\item{domgross}{Domestic gross in $USD in release year}
\item{intgross}{International gross in $USD in release year}
\item{plot}{Plot of the movie}
\item{rated}{Moving rating, e.g. PG, PG-13, R, etc.}
\item{language}{Language of the movie}
\item{country}{Country where the movie was produced}
\item{imdb_rating}{IMDB rating of the movie, 0-10}
\item{director}{Director of the movie}
\item{actors}{Major actors appearing in the movie}
\item{genre}{Genre}
\item{awards}{Awards won by the movie, text description}
\item{runtime}{Movie runtime in minutes}
\item{poster}{URL of movie poster image, sourced from \href{https://www.themoviedb.org}{themoviedb.org}. Poster images URLs ar provided from the TMDB API but \pkg{epoxy} is not endorsed or certified by TMDB.}
}
}
\source{
\href{https://github.com/rfordatascience/tidytuesday/blob/044e769/data/2021/2021-03-09/readme.md}{TidyTuesday (2021-03-09)},
\href{https://github.com/fivethirtyeight/data/tree/master/bechdel}{FiveThirtyEight},
\href{https://bechdeltest.com/}{bechdeltest.com},
\href{https://www.themoviedb.org}{themoviedb.org}
}
\usage{
bechdel
}
\description{
A small dataset for \pkg{epoxy} demonstrations with the top audience-rated
movies that pass the \href{https://bechdeltest.com}{Bechdel Test}.
}
\keyword{datasets}
