% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/writeNeuroTable.R
\name{sortTableByRefMatches}
\alias{sortTableByRefMatches}
\title{Sort table by scoring for each row}
\usage{
sortTableByRefMatches(dntk)
}
\arguments{
\item{dntk}{the table returned from writeNeuroTable}
}
\value{
the sorted table
}
\description{
Sort table by scoring for each row
}
\examples{
utils::data(rawDrugNamesCoOcEpSO, package="epos")
utils::data(rawDrugNamesCoOcESSO, package="epos")
utils::data(rawDrugNamesCoOcEPILONT, package="epos")
utils::data(rawDrugNamesCoOcEPISEM, package="epos")
utils::data(rawDrugNamesCoOcFENICS, package="epos")
atchashda <-
readAtcMapIntoHashMapDrugNamesAtcCodes(
  system.file("extdata", "db-atc.map", package = "epos"), "\t")
atchashaa <-
  readAtcMapIntoHashMapAtcCodesAtcNames(
    system.file("extdata", "db-atc.map", package = "epos"), "\t")
atchashsec <-
  readSecondLevelATC(
    system.file("extdata", "atc-secondlevel.map", package = "epos"), "\t")
epso <- rawDrugNamesCoOcEpSO
neuroepso <- filterNeuroDrugs(epso, atchashda)
esso <- rawDrugNamesCoOcESSO
neuroesso   <- filterNeuroDrugs(esso, atchashda)
epi <- rawDrugNamesCoOcEPILONT
neuroepi    <- filterNeuroDrugs(epi, atchashda)
episem <- rawDrugNamesCoOcEPISEM
neuroepisem <- filterNeuroDrugs(episem, atchashda)
fenics <- rawDrugNamesCoOcFENICS
neurofenics <- filterNeuroDrugs(fenics, atchashda)
mx <- max(
    c(length(neuroepso), length(neuroesso), length(neuroepi),
      length(neuroepisem), length(neurofenics)))
dneuro <-
  data.frame(EpSO = c(neuroepso, rep("", (mx-length(neuroepso)))),
             ESSO = c(neuroesso, rep("", (mx-length(neuroesso)))),
             EPILONT = c(neuroepi, rep("", (mx-length(neuroepi)))),
             EPISEM = c(neuroepisem, rep("", (mx-length(neuroepisem)))),
             FENICS = c(neurofenics, rep("", (mx-length(neurofenics)))))
suppressWarnings(dneuromaxk <- TopKLists::calculate.maxK(dneuro, L=5, d=5, v=5))
neurotable <- createNeuroTable(atchashda, atchashsec, dneuromaxk)
sortedNeuroTable <- sortTableByRefMatches(neurotable)
\dontrun{
print(xtable::xtable(sortedNeuroTable, type = "latex"),
  file = "sortedNeuroTable.tex",
  include.rownames=FALSE)
}
}
