% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/epitrax.R
\name{epitrax_ireport_ytd_counts_for_month}
\alias{epitrax_ireport_ytd_counts_for_month}
\title{Create year-to-date (YTD) counts internal report for a given month
from an EpiTrax object}
\usage{
epitrax_ireport_ytd_counts_for_month(epitrax, as.rates = FALSE)
}
\arguments{
\item{epitrax}{Object of class \code{epitrax}.}

\item{as.rates}{Logical. If TRUE, returns rates per 100k instead of raw counts.}
}
\value{
Updated EpiTrax object with report added to the \code{internal_reports} field.
}
\description{
\code{epitrax_ireport_ytd_counts_for_month} generates an internal report of
year-to-date counts up to a specific month in the EpiTrax object data.
}
\examples{
data_file <- system.file("sample_data/sample_epitrax_data.csv",
                         package = "epitraxr")
config_file <- system.file("tinytest/test_files/configs/good_config.yaml",
                           package = "epitraxr")
disease_lists <- list(
  internal = "use_defaults",
  public = "use_defaults"
)

epitrax <- setup_epitrax(
  filepath = data_file,
  config_file = config_file,
  disease_list_files = disease_lists
) |>
 epitrax_ireport_ytd_counts_for_month(as.rates = TRUE)

names(epitrax$internal_reports)
}
