% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gt_univariate_crosstabs.R
\name{add_crosstabs}
\alias{add_crosstabs}
\title{A \{gtsummary\} wrapper function that takes a gtsummary univariate regression
table and adds appropriate cross tabs by exposure and outcome}
\usage{
add_crosstabs(x, wide = FALSE)
}
\arguments{
\item{x}{Object with class \code{tbl_uvregression} from the gtsummary
tbl_uvregression function or \code{tbl_cmh} from the epitabulate tbl_cmh function.}

\item{wide}{TRUE/FALSE to specify whether would like to have the output in
wide format. Results in four columns rather than two, but in a single row.
This is only works for dichotomous variables (yes/no, TRUE/FALSE,
male/female), others will be dropped with a warning message. (Default is FALSE)}
}
\value{
A modified \code{gtsummary} table object (same class as input — e.g.
\code{"tbl_uvregression"} or \code{"tbl_cmh"}) containing additional cross-tabulated
counts of outcomes and exposures. The structure depends on regression type:
\itemize{
\item For logistic models: adds case and control counts.
\item For Poisson models without offsets: adds total and case counts per exposure group (risk ratios).
\item For Poisson models with offsets: adds total person-time and case counts per exposure group (incidence rate ratios).
\item When \code{wide = TRUE}, dichotomous variables are reshaped to wide format with separate columns for exposed/unexposed counts.
}
}
\description{
A \{gtsummary\} wrapper function that takes a gtsummary univariate regression
table and adds appropriate cross tabs by exposure and outcome
}
\references{
Inspired by Daniel Sjoberg,
see \href{https://github.com/ddsjoberg/gtsummary}{gtsummary github repo}
}
