% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/link_ae_inpatient.R
\name{link_ae_inpatient}
\alias{link_ae_inpatient}
\title{Link A&E to Inpatient records}
\usage{
link_ae_inpatient(
  ae_data,
  ae_in,
  ae_out,
  inpatient_data,
  admission_date,
  spell_id,
  nhs_number = c("nhs_number", "nhs_number"),
  hospital_number = c("local_patient_identifier", "local_patient_identifier"),
  patient_dob = c("patient_birth_date", "date_birth"),
  org_code = c("organisation_code_of_provider", "organisation_code_code_of_provider"),
  .forceCopy = FALSE
)
}
\arguments{
\item{ae_data}{the ECDS A&E dataset}

\item{ae_in}{the ECDS arrival date}

\item{ae_out}{the ECDS discharge date}

\item{inpatient_data}{the HES/SUS inpatient dataset}

\item{admission_date}{a vector containing the inpatient (HES/SUS) admission date}

\item{spell_id}{the HES/SUS spell id}

\item{nhs_number}{a vector containing the columns for the NHS numbers}

\item{hospital_number}{a vector containing the columns for the Hospital numbers}

\item{patient_dob}{a vector containing the columns for the date of birth}

\item{org_code}{a vector containing the columns for the organisation codes}

\item{.forceCopy}{a boolean to control if you want to copy the dataset before
linking together}
}
\value{
a patient level linked hospital record
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#experimental}{\figure{lifecycle-experimental.svg}{options: alt='[Experimental]'}}}{\strong{[Experimental]}}

Link together ECDS A&E records to HES/SUS inpatient records on
NHS number, Hospital Number and Date of Birth.
}
\seealso{
group_time continuous_inpatient_spells
}
