% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dict_rename_helper.R
\name{dict_rename_helper}
\alias{dict_rename_helper}
\title{Dictionary-based helper for aligning your data to variables used in a script}
\usage{
dict_rename_helper(
  dictionary,
  varnames,
  varnames_type,
  rmd,
  copy_to_clipboard = TRUE
)
}
\arguments{
\item{dictionary}{A dataframe of the dictionary which you would like to use.}

\item{varnames}{The name of \code{dictionary} column that contains variable names.}

\item{varnames_type}{The name of \code{dictionary} column that contains the variable type.
This variable needs to be the same number of rows as as \code{varnames}.}

\item{rmd}{Path to the Rmarkdown file which you would like to compare to.}

\item{copy_to_clipboard}{if \code{TRUE} (default), the rename template will be
copied to the user's clipboard with \code{\link[clipr:write_clip]{clipr::write_clip()}}. If \code{FALSE}, the
rename template will be printed to the user's console.}
}
\value{
A dplyr command used to rename columns in your data frame according
to the dictionary
}
\description{
Dictionary-based helper for aligning your data to variables used in a script
}
\seealso{
\code{\link[=read_dict]{read_dict()}}
}
