% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generalFunctions.R
\name{summary.KRDetect}
\alias{summary.KRDetect}
\title{Summary of the outlier detection results}
\usage{
\method{summary}{KRDetect}(object, ...)
}
\arguments{
\item{object}{a KRDetect object obtained as an output of function \code{\link{KRDetect.outliers.changepoint}}, \code{\link{KRDetect.outliers.controlchart}} or \code{\link{KRDetect.outliers.EV}} for identification of outliers.}

\item{...}{further arguments to be passed to the \code{\link{summary}} function.}
}
\description{
Summary of results obtained using functions \code{\link{KRDetect.outliers.changepoint}}, \code{\link{KRDetect.outliers.controlchart}} and \code{\link{KRDetect.outliers.EV}} for identification of outliers.
}
\details{
The function summarizes the results obtained using functions \code{\link{KRDetect.outliers.changepoint}}, \code{\link{KRDetect.outliers.controlchart}} and \code{\link{KRDetect.outliers.EV}} for identification of outliers.
}
\examples{
data("mydata", package = "openair")
x = mydata$o3[format(mydata$date, "\%m \%Y") == "12 2002"]
result = KRDetect.outliers.changepoint(x)
summary(result)
result = KRDetect.outliers.controlchart(x)
summary(result)
result = KRDetect.outliers.EV(x)
summary(result)
}
