% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/env_doc.R
\name{env_doc}
\alias{env_doc}
\title{Report the working environment in which an analysis was performed.}
\usage{
env_doc(
  output = c("return", "print", "table"),
  system = TRUE,
  version = TRUE,
  packages = TRUE,
  script = TRUE,
  git = TRUE,
  renv = TRUE,
  domino = c("auto", "on", "off")
)
}
\arguments{
\item{output}{How should output be handled? Character, values: 
return - return as a data frame (default);
 print - print to stdout; 
 table - pretty-print
using knitr::kable (requires package knitr)}

\item{system}{Include OS info from \code{\link{getSysInfo}}? Boolean, 
default TRUE}

\item{version}{Include R version from \code{\link{getRversion}}?
Boolean, default TRUE}

\item{packages}{Include attached packages with repository and version from 
\code{\link{getPackageInfo}}? Boolean, default TRUE}

\item{script}{Include script path and modification time from 
\code{\link{getScriptInfo}}? Boolean, default TRUE}

\item{git}{Include git repository information from \code{\link{getGitInfo}}
(note: requires \code{git2r})?  Boolean, default TRUE}

\item{renv}{Include \code{renv} status information from 
\code{\link{getRenvStatus}}? Boolean, default TRUE}

\item{domino}{Include Domino Datalab run information from 
\code{\link{getDominoInfo}}?  Character, values:
auto - include if available; 
on - include with warning if not available; 
off - do not include evn if available}
}
\value{
If output = return (default): A data frame with columns for information 
  type, variable name and value.  NULL for output = print or output = table
}
\description{
\code{env_doc} prints or returns a data frame with the following information:  
- System version (OS, version, user, working directory)
}
\details{
- R version  

- Package names and versions  

- Top-level script name and modification time  

- Git hash, status and tag (if any; requires package git2r)
}
\examples{
\dontrun{ 
 # Note that these only work when called in a script or markdown document
 env_doc("print") # print information to stdout
 info <- env_doc() # return information as a consolidated data frame
 }
}
