% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rel_test.R
\name{rel_test}
\alias{rel_test}
\title{Test Reliability and CSEMs for IRT Scores}
\usage{
rel_test(ip, ct = NULL, nq = 11, D = 1.702)
}
\arguments{
\item{ip}{A data frame or matrix of item parameters. Columns are interpreted
in order as:
\itemize{
\item 3 columns: \code{b}, \code{a}, \code{c} (3PL; \code{a} on the \code{D} metric),
\item 2 columns: \code{b}, \code{a} (2PL; \code{c} internally set to 0),
\item 1 column: \code{b} (1PL/Rasch; \code{a = 1}, \code{c = 0}).
}}

\item{ct}{Optional. A data frame or matrix containing the score conversion
table. If supplied, it must have \code{ni + 1} rows (for raw scores
\code{0:ni}) and a column named \code{ss} giving the corresponding
scale scores. If \code{ct = NULL} (default), only raw-score reliability and
CSEMs are computed.}

\item{nq}{Integer. Number of quadrature points used to approximate the
standard normal ability distribution. Defaults to \code{11}.}

\item{D}{Numeric. Scaling constant for the logistic IRT model. Defaults to
\code{1.702}.}
}
\value{
A list with three components:
\describe{
\item{fx}{A data frame containing the estimated marginal
score distribution for raw scores (and scale scores if \code{ct} is
provided).}
\item{rel}{A data frame with overall error variance,
true score variance, observed score variance, and reliability for raw
scores, and additionally for scale scores if \code{ct} is provided.}
\item{csem}{A data frame with theta, weights, expected raw
scores and corresponding CSEMs. If \code{ct} is provided, expected scale
scores and scale-score CSEMs are also included.}
}
}
\description{
Compute test reliability for raw scores (and optionally scale scores),
along with associated conditional standard errors of measurement (CSEMs),
for a unidimensional IRT model.
}
\examples{
data(ip.u)
data(ct.u)
rel_test(ip.u)
rel_test(ip.u, ct.u)

}
