% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/core-svg.R
\name{as_svg_anim}
\alias{as_svg_anim}
\title{Wrap multiple emphatic object into an SVG animation}
\usage{
as_svg_anim(
  x,
  width = 1200,
  height = 900,
  duration = 1,
  playback = c("infinite", "click"),
  font_size = NULL,
  style = list(),
  svg_id = NULL,
  browsable = FALSE
)
}
\arguments{
\item{x}{list of emphatic objects}

\item{width, height}{viewBox dimensions for SVG}

\item{duration}{frame duration in seconds. May be a single value used for
all frames, or a vector of values (one duration value for each frame).
Can be fractions of a second.}

\item{playback}{'click', 'infinite'}

\item{font_size}{CSS font-size. Default: NULL means to not adjust font size.
Otherwise, use valid CSS \code{font-size} specification e.g.
"3em", "22px" etc.}

\item{style}{html tag styling to apply to the \code{<pre>} wrapper for the
returned HTML}

\item{svg_id}{ID to use for the SVG tag.  Default: NULL means to create a random
ID}

\item{browsable}{Should the SVG be rendered to the RStudio Viewer pane when
when printed (instead of console output)? Default: FALSE}
}
\value{
Character string containing an animated SVG representation displaying
        all elements sequentially
}
\description{
Idea borrowed from pointblank
}
\examples{
list(
  hl_diff('hello', 'there'),
  hl_diff('goodbye', 'good boy')
) |>
  as_svg_anim() |>
  cat()
}
