## ----include = FALSE----------------------------------------------------------
knitr::opts_chunk$set(
  collapse = TRUE,
  comment = "#>"
)
library(ggplot2)
library(emphatic)

## ----setup--------------------------------------------------------------------
library(ggplot2)
library(emphatic)

## -----------------------------------------------------------------------------
test_df <- head(mtcars, 10)

## -----------------------------------------------------------------------------
test_df |>
  hl('skyblue')

## -----------------------------------------------------------------------------
test_df |>
  hl('skyblue', cols = NULL)

## -----------------------------------------------------------------------------
test_df |>
  hl('skyblue', cols = all())

## -----------------------------------------------------------------------------
test_df |>
  hl('skyblue', cols = 2:5)

## -----------------------------------------------------------------------------
test_df |>
  hl('skyblue', cols = c('mpg', 'gear'))

## -----------------------------------------------------------------------------
test_df |>
  hl('skyblue', cols = c(drat, am))

## -----------------------------------------------------------------------------
test_df |>
  hl('skyblue', cols = drat:am)

## -----------------------------------------------------------------------------
test_df |>
  hl('skyblue', cols = col_number() < 4)

## -----------------------------------------------------------------------------
test_df |>
  hl('skyblue', cols = contains('a'))

## -----------------------------------------------------------------------------
test_df |>
  hl('skyblue', cols = ends_with('t'))

## -----------------------------------------------------------------------------
test_df |>
  hl('skyblue', cols = any_of(c('mpg', 'wt', 'age')))

