% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/layers.R
\name{emodnet_get_layers}
\alias{emodnet_get_layers}
\title{Get EMODnet WFS datasets (layers)}
\usage{
emodnet_get_layers(
  wfs = NULL,
  service = NULL,
  service_version = NULL,
  layers,
  crs = NULL,
  cql_filter = NULL,
  simplify = FALSE,
  reduce_layers = deprecated(),
  ...
)
}
\arguments{
\item{wfs}{A \code{WFSClient} R6 object with methods for interfacing an
OGC Web Feature Service. From \code{\link[=emodnet_init_wfs_client]{emodnet_init_wfs_client()}}.}

\item{service}{the EMODnet OGC WFS service name.
For available services, see \code{\link[=emodnet_wfs]{emodnet_wfs()}}.}

\item{service_version}{\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#deprecated}{\figure{lifecycle-deprecated.svg}{options: alt='[Deprecated]'}}}{\strong{[Deprecated]}}
the WFS service version. Now always "2.0.0".}

\item{layers}{a character vector of layer names. To get info on layers,
including
\code{layer_name} use \code{\link[=emodnet_get_wfs_info]{emodnet_get_wfs_info()}}.}

\item{crs}{integer. EPSG code for the output crs. If \code{NULL} (default), layers
are returned with original crs.}

\item{cql_filter}{character. Features returned can be filtered using valid
Extended Common Query Language (ECQL) filtering statements
(\url{https://docs.geoserver.org/stable/en/user/filter/ecql_reference.html}).
Should be one of:
\itemize{
\item character string or character vector of length 1.
Filter will be recycled across all layers requested.
\item character vector of length equal to the length of layers.
Filter will be matched to layers sequentially.
Elements containing \code{NA} are ignored
\item named character vector. Each filter will be applied to the layer
corresponding to the filter name.
Filters with names that do not correspond to any layers are ignored.
Layers without corresponding filters are returned whole.
}}

\item{simplify}{whether to reduce output layers to a single \code{sf} object.
This only works if the column names are the same.}

\item{reduce_layers}{\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#deprecated}{\figure{lifecycle-deprecated.svg}{options: alt='[Deprecated]'}}}{\strong{[Deprecated]}} use \code{simplify}.}

\item{...}{additional vendor parameter arguments passed to
\href{https://docs.geoserver.org/stable/en/user/services/wfs/reference.html#getfeature}{\code{ows4R::GetFeature()}}.
For example, including \code{count = 1} returns the first available feature.
Or \code{outputFormat = "CSV"} (or \code{outputFormat = "JSON"}) might help downloading
bigger datasets.}
}
\value{
If \code{simplify = FALSE} (default), a list of \code{sf}
objects, one element for each layer. Any layers for which download was
unsuccessful will be NULL. If \code{simplify = TRUE}, all layers are
reduced (if possible: if all
column names are the same) to a single \code{sf} containing data for all layers.
\code{NULL} layers are ignored. \code{simplify = TRUE} can also be used to return
an \code{sf} out of a single layer request instead of a list of length 1.
}
\description{
Performs an WFS getFeature request for layers from a \code{wfs} object or
specified EMODnet Service. Filtering
of layer features can also be handled via ECQL language filters.
}
\section{Big downloads}{


If a layer is really big (like \code{"abiotic_observations"} of the
\code{"biology_occurrence_data"} service),
you might consider a combination of these ideas:
\itemize{
\item using \href{https://docs.geoserver.org/stable/en/user/services/wfs/reference.html#getfeature}{\code{outputFormat = "CSV"}};
\item filtering using \href{https://docs.ropensci.org/emodnet.wfs/articles/ecql_filtering.html}{\code{cql_filters}} or
\href{https://docs.ropensci.org/emodnet.wfs/articles/request-params.html#limit-spatial-extent-using-a-boundary-box}{bounding boxes}
(possibly splitting the area of interests into several requests);
\item Using \href{https://emodnet.ec.europa.eu/geoviewer/}{EMODnet's download toolbox}.
}
}

\examples{
\dontshow{if (should_run_example()) withAutoprint(\{ # examplesIf}
# Layers as character vector
emodnet_get_layers(
  service = "biology",
  layers = c("mediseh_zostera_m_pnt", "mediseh_posidonia_nodata")
)


# Usage of cql_filter
emodnet_get_layers(
  service = "biology",
  layers = "mediseh_zostera_m_pnt",
  cql_filter = "country = 'Francia'"
)
# Usage of vendor parameter
emodnet_get_layers(
  service = "biology",
  layers = "mediseh_zostera_m_pnt",
  count = 1
)

# Usage of csv output
data <- emodnet_get_layers(
    service = "biology_occurrence_data",
    layers = "abiotic_observations",
    outputFormat = "CSV"
)
str(data[["abiotic_observations"]])
\dontshow{\}) # examplesIf}
}
