% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/energy_ratios.R
\name{ner_func}
\alias{ner_func}
\title{Calculate Net Energy Return (Nh)}
\usage{
ner_func(g, s, se = NULL)
}
\arguments{
\item{g}{Numeric vector of gross income values}

\item{s}{Numeric vector of energy spending values}

\item{se}{Optional numeric vector of effective energy spending (defaults to s)}
}
\value{
Numeric vector of Net Energy Return (Nh) values
}
\description{
Calculates the Net Energy Return using the formula Nh = (G - S) / Se,
where G is gross income, S is energy spending, and Se is effective energy
spending. This metric is the preferred aggregation variable as it properly
accounts for harmonic mean behavior when aggregating across households.
}
\details{
The Net Energy Return is mathematically related to energy burden by:
E_b = 1 / (Nh + 1), or equivalently: Nh = (1/E_b) - 1

\strong{Why use Nh for aggregation?}

For individual household data, the Nh method enables simple arithmetic weighted
mean aggregation:
\itemize{
\item \strong{Via Nh}: \code{neb = 1 / (1 + weighted.mean(nh, weights))} (arithmetic mean)
\item \strong{Direct EB}: \code{neb = 1 / weighted.mean(1/eb, weights)} (harmonic mean)
}

\strong{Computational advantages of the arithmetic mean approach:}
\enumerate{
\item \strong{Simpler to compute} - Uses standard \code{weighted.mean()} function
\item \strong{More numerically stable} - Avoids division by very small EB values (e.g., 0.01)
\item \strong{More interpretable} - "Average net return per dollar spent on energy"
\item \strong{Prevents errors} - Makes it obvious you can't use arithmetic mean on EB directly
}

For cohort data (pre-aggregated totals), direct calculation \code{sum(S)/sum(G)}
is mathematically equivalent to the Nh method but simpler.

The 6\% energy burden poverty threshold corresponds to Nh \eqn{\ge} 15.67.
}
\examples{
# Calculate Net Energy Return
gross_income <- 50000
energy_spending <- 3000
nh <- ner_func(gross_income, energy_spending)

# Convert back to energy burden
energy_burden <- 1 / (nh + 1)
}
