% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/oauth.R
\name{eg_oauth_authorize}
\alias{eg_oauth_authorize}
\title{Authorize with Egnyte via OAuth 2.0}
\usage{
eg_oauth_authorize(scope = "Egnyte.filesystem")
}
\arguments{
\item{scope}{Character vector of OAuth scopes to request. Defaults to
\code{"Egnyte.filesystem"} for file operations. Other scopes include
\code{"Egnyte.link"}, \code{"Egnyte.user"}, and \code{"Egnyte.projectfolders"}.}
}
\value{
Invisibly returns a list containing \code{access_token}, \code{refresh_token},
\code{token_type}, and \code{expires_in}.
}
\description{
Initiates the OAuth 2.0 Authorization Code flow. This opens a browser
window for the user to log in and authorize the application, then
prompts for the authorization code to exchange for access tokens.
}
\details{
The OAuth flow:
\enumerate{
\item Opens a browser to Egnyte's authorization page
\item User logs in (via SSO if configured) and approves access
\item Egnyte redirects to your configured redirect_uri with \code{?code=...}
\item Copy the code from the URL and paste it when prompted
\item The code is exchanged for access and refresh tokens
}

\strong{Note:} Egnyte requires HTTPS redirect URIs. After authorization, you'll
be redirected to your configured URI. Copy the \code{code} parameter from the
URL (everything after \verb{code=} and before any \code{&}).

Access tokens expire after 30 days. Use \code{\link[=eg_oauth_refresh]{eg_oauth_refresh()}} to obtain
a new token using the refresh token.
}
\examples{
\dontrun{
# First set up your OAuth app
eg_oauth_app("mycompany", "client_id", "client_secret",
             redirect_uri = "https://your-app.com/callback")

# Then authorize (opens browser, prompts for code)
eg_oauth_authorize()

# Now you can use eg_read() and eg_write()
eg_read("/Shared/Documents/file.txt", "local.txt")
}

}
\seealso{
\code{\link[=eg_oauth_app]{eg_oauth_app()}} to configure the OAuth application first.
}
