% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rcrds.R
\name{expect_rcrds}
\alias{expect_rcrds}
\title{Set the expected values for recording variables}
\usage{
expect_rcrds(.edibble = NULL, ..., .record = TRUE)
}
\arguments{
\item{.edibble}{An edibble design (\code{edbl_design}), an edibble data frame (\code{edbl_table}) or an
object that contains the edibble data frame in the attribute
\code{design}.}

\item{...}{Name-value pairs with the name belonging to the variable
that are plan to be recorded from \code{set_rcrds()} and the values are
the expected types and values set by helper functions, see \code{?expect-rcrds}.}

\item{.record}{A logical value. This indicates whether to record this
code step. The default is TRUE. It should remain TRUE unless this
function is used as a wrapper in other code.}
}
\value{
An edibble design.
}
\description{
Set the expected values for recording variables
}
\examples{
takeout(menu_crd(t = 4, n = 10)) \%>\%
  set_rcrds(y = unit) \%>\%
  expect_rcrds(y > 0)
}
\seealso{
Other user-facing functions: 
\code{\link{allot_trts}()},
\code{\link{allot_units}()},
\code{\link{design}()},
\code{\link{export_design}()},
\code{\link{serve_table}()},
\code{\link{set_rcrds}()},
\code{\link{set_trts}()},
\code{\link{set_units}()}
}
\concept{user-facing functions}
