% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Exam4.3.R
\name{Exam4.3}
\alias{Exam4.3}
\title{Example 4.3 from Experimental Design and Analysis for Tree Improvement}
\description{
Exam4.3 presents the germination count data for 4 Pre-Treatments and 6 Seedlots.
}
\examples{
library(car)
library(dae)
library(dplyr)
library(emmeans)
library(ggplot2)
library(lmerTest)
library(magrittr)
library(predictmeans)

data(DataExam4.3)

 # Pg. 50
 fm4.2    <-
   aov(
       formula =
       percent ~ repl + contcomp + seedlot +
                 treat/contcomp + contcomp/seedlot +
                 treat/contcomp/seedlot
      , data   = DataExam4.3
     )

 # Pg. 54
 anova(fm4.2)

 # Pg. 54
 model.tables(x = fm4.2, type = "means")

 emmeans(object = fm4.2, specs = ~ contcomp)
 emmeans(object = fm4.2, specs = ~ seedlot)
 emmeans(object = fm4.2, specs = ~ contcomp + treat)
 emmeans(object = fm4.2, specs = ~ contcomp + seedlot)
 emmeans(object = fm4.2, specs = ~ contcomp + treat + seedlot)

 DataExam4.3 \%>\%
   dplyr::group_by(treat, contcomp, seedlot) \%>\%
   dplyr::summarize(Mean = mean(percent))
   RESFIT <-
          data.frame(
           residualvalue = residuals(fm4.2)
         , fittedvalue   = fitted.values(fm4.2)
         )

   ggplot(mapping = aes(
                         x = fitted.values(fm4.2)
                       , y = residuals(fm4.2))) +
   geom_point(size = 2) +
   labs(
       x = "Fitted Values"
     , y = "Residuals"
     ) +
     theme_classic()

}
\references{
\enumerate{
         \item E.R. Williams, C.E. Harwood and A.C. Matheson (2023). \emph{Experimental Design and Analysis for Tree Improvement}.
               CSIRO Publishing (\href{https://www.publish.csiro.au/book/3145/}{https://www.publish.csiro.au/book/3145/}).
             }
}
\seealso{
\code{\link{DataExam4.3}}
}
\author{
\enumerate{
         \item  Muhammad Yaseen (\email{myaseen208@gmail.com})
         \item  Sami Ullah (\email{samiullahuos@gmail.com})
         }
}
