% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/operator.selector.k-tournament.R
\name{selTournament}
\alias{selTournament}
\title{k-Tournament selector.}
\usage{
selTournament(fitness, n.select, k = 3L)
}
\arguments{
\item{fitness}{[\code{matrix}]\cr
Matrix of fitness values (each column contains the fitness value(s) of one
individual).}

\item{n.select}{[\code{integer(1)}]\cr
Number of elements to select.}

\item{k}{[\code{integer(1)}]\cr
Number of individuals to participate in each tournament. Default is \code{2L}.}
}
\value{
[\code{integer}] Vector of survivor indizes.
}
\description{
k individuals from the population are chosen randomly and the best one is
selected to be included into the mating pool. This process is repeated until
the desired number of individuals for the mating pool is reached.
}
\seealso{
Other selectors: 
\code{\link{selDomHV}()},
\code{\link{selGreedy}()},
\code{\link{selNondom}()},
\code{\link{selRanking}()},
\code{\link{selRoulette}()},
\code{\link{selSimple}()}
}
\concept{selectors}
