% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PA.EMOA.plotScatter3d.R
\name{plotScatter3d}
\alias{plotScatter3d}
\title{Visualize three-objective Pareto-front approximations.}
\usage{
plotScatter3d(
  df,
  obj.cols = c("f1", "f2", "f3"),
  max.in.row = 4L,
  package = "scatterplot3d",
  ...
)
}
\arguments{
\item{df}{[\code{data.frame}]\cr
Data.frame with columns at least \code{obj.cols}, \dQuote{prob} and \dQuote{algorithm}.}

\item{obj.cols}{[\code{character(>= 3)}]\cr
Column names of the objective functions.
Default is \code{c("f1", "f2", "f3")}.}

\item{max.in.row}{[\code{integer(1)}]\cr
Maximum number of plots to be displayed side by side in a row.
Default is 4.}

\item{package}{[\code{character(1L)}]\cr
Which package to use for 3d scatterplot generation?
Possible choices are \dQuote{scatterplot3d}, \dQuote{plot3D}, \dQuote{plot3Drgl}
or \dQuote{plotly}.
Default is \dQuote{scatterplot3d}.}

\item{...}{[any]\cr
Further arguments passed down to scatterplot function.}
}
\value{
Nothing
}
\description{
Given a data frame with the results of (multiple) runs of (multiple)
different three-objective optimization algorithms on (multiple) problem instances
the function generates 3D scatterplots of the obtained Pareto-front approximations.
}
\seealso{
Other EMOA performance assessment tools: 
\code{\link{approximateNadirPoint}()},
\code{\link{approximateRefPoints}()},
\code{\link{approximateRefSets}()},
\code{\link{computeDominanceRanking}()},
\code{\link{emoaIndEps}()},
\code{\link{makeEMOAIndicator}()},
\code{\link{niceCellFormater}()},
\code{\link{normalize}()},
\code{\link{plotDistribution}()},
\code{\link{plotFront}()},
\code{\link{plotScatter2d}()},
\code{\link{toLatex}()}
}
\concept{EMOA performance assessment tools}
