% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/operator.selector.ranking.R
\name{selRanking}
\alias{selRanking}
\title{Rank Selection Operator}
\usage{
selRanking(fitness, n.select, s = 1.5, scheme = "linear")
}
\arguments{
\item{fitness}{[\code{matrix}]\cr
Matrix of fitness values (each column contains the fitness value(s) of one
individual).}

\item{n.select}{[\code{integer(1)}]\cr
Number of elements to select.}

\item{s}{[\code{numeric(1)}]\cr
Selection pressure for linear ranking scheme with value range \eqn{[0,1]}.
Ignored if \code{scheme} is set to \dQuote{exponential}.
Default is 1.5.}

\item{scheme}{[\code{character(1)}]\cr
Mapping from rank number to selection probability, either
\dQuote{linear} or \dQuote{exponential}.}
}
\value{
[\code{setOfIndividuals}]
}
\description{
Rank-based selection preserves a constant selection pressure by sorting the
population on the basis of fitness, and then allocating selection
probabilities to individuals according to their rank, rather than according
to their actual fitness values.
}
\references{
Eiben, A. E., & Smith, J. E. (2007). Introduction to evolutionary computing.
Berlin: Springer.
}
\seealso{
Other selectors: 
\code{\link{selDomHV}()},
\code{\link{selGreedy}()},
\code{\link{selNondom}()},
\code{\link{selRoulette}()},
\code{\link{selSimple}()},
\code{\link{selTournament}()}
}
\concept{selectors}
