% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PA.EMOA.latex.formatters.R
\name{niceCellFormater}
\alias{niceCellFormater}
\title{Formatter for table cells of LaTeX tables.}
\usage{
niceCellFormater(cell, alpha = 0.05)
}
\arguments{
\item{cell}{[any]\cr
Cell value. In the majority of cases this will be a numeric value.}

\item{alpha}{[\code{numeric(1)}]\cr
Significance level of underlying statistical test.
Default is 0.05.}
}
\value{
Formatted output.
}
\description{
This formatter function should be applied to
tables where each table cell contains a \eqn{p}-value of
a statistical significance test. See \code{\link{toLatex}}
for an application.
}
\seealso{
Other EMOA performance assessment tools: 
\code{\link{approximateNadirPoint}()},
\code{\link{approximateRefPoints}()},
\code{\link{approximateRefSets}()},
\code{\link{computeDominanceRanking}()},
\code{\link{emoaIndEps}()},
\code{\link{makeEMOAIndicator}()},
\code{\link{normalize}()},
\code{\link{plotDistribution}()},
\code{\link{plotFront}()},
\code{\link{plotScatter2d}()},
\code{\link{plotScatter3d}()},
\code{\link{toLatex}()}
}
\concept{EMOA performance assessment tools}
