% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stability.R
\name{print.velocity}
\alias{print.velocity}
\title{Print Brief Details of a Phase Velocity Vector}
\usage{
\method{print}{velocity}(x, ...)
}
\arguments{
\item{x}{Object of class "\code{velocity}".}

\item{...}{Ignored.}
}
\value{
No value
}
\description{
Prints a very brief description of a phase velocity vector.
}
\examples{
eq1 <- function(x, y, r1 = 4, a11 = 1, a12 = 2) (r1 - a11 * x - a12 * y) * x
eq2 <- function(x, y, r2 = 1, a21 = 2, a22 = 1) (r2 - a21 * x - a22 * y) * y
x <- eode(dxdt = eq1, dydt = eq2)
eode_get_velocity(x, value = pp(list(x = 1, y = 1)))
}
