% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stability.R
\name{plot.velocity}
\alias{plot.velocity}
\title{Create a Plot of a Phase Velocity Vector}
\usage{
\method{plot}{velocity}(x, ...)
}
\arguments{
\item{x}{Object of class "\code{velocity}".}

\item{...}{Ignored.}
}
\value{
ggplot object
}
\description{
Plot a phase velocity vector
}
\examples{
eq1 <- function(x, y, r1 = 4, a11 = 1, a12 = 2) (r1 - a11 * x - a12 * y) * x
eq2 <- function(x, y, r2 = 1, a21 = 2, a22 = 1) (r2 - a21 * x - a22 * y) * y
x <- eode(dxdt = eq1, dydt = eq2)
plot(eode_get_velocity(x, value = pp(list(x = 1, y = 1))))
}
