% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simulation.R
\name{eode_proj}
\alias{eode_proj}
\title{Solve ODEs}
\usage{
eode_proj(x, value0, N, step = 0.01)
}
\arguments{
\item{x}{the ODE system under consideration. An object of class "\code{eode}".}

\item{value0}{value an object of class "\code{pp}" representing the phase point
at the initial state.}

\item{N}{number of iterations}

\item{step}{interval of time for each step}
}
\value{
an object of class "\code{pc}" that represents a phase curve
}
\description{
Provides the numerical solution of an ODE under consideration given an initial
condition.
}
\examples{
## Example1: Lotka-Volterra competition model
eq1 <- function(x, y, r1 = 4, a11 = 1, a12 = 2) (r1 - a11 * x - a12 * y) * x
eq2 <- function(x, y, r2 = 1, a21 = 2, a22 = 1) (r2 - a21 * x - a22 * y) * y
x <- eode(dxdt = eq1, dydt = eq2, constraint = c("x<1", "y<1"))
eode_proj(x, value0 = pp(list(x = 0.2, y = 0.1)), N = 100)

## Example2: Susceptible-infected model
dX_Cdt <- function(X_C, Y_C, X_A, Y_A, nu = 0.15, beta = 0.1, mu = 0.15, g = 0.04) {
  nu * (X_A + Y_A) - beta * X_C * (Y_C + Y_A) - (mu + g) * X_C
}

dY_Cdt <- function(X_C, Y_C, Y_A, beta = 0.1, mu = 0.15, g = 0.04, rho = 0.2) {
  beta * X_C * (Y_C + Y_A) - (mu + g + rho) * Y_C
}

dX_Adt <- function(X_C, Y_C, X_A, Y_A, beta = 0.1, g = 0.04) {
  g * X_C - beta * X_A * (Y_C + Y_A)
}

dY_Adt <- function(X_A, Y_C, Y_A, beta = 0.1, g = 0.04, rho = 0.2) {
  beta * X_A * (Y_C + Y_A) + g * Y_C - rho * Y_A
}

x <- eode(
  dX_Cdt = dX_Cdt, dY_Cdt = dY_Cdt, dX_Adt = dX_Adt, dY_Adt = dY_Adt,
  constraint = c("X_C>=0", "Y_C>=0", "X_A>=0", "Y_A>=0")
)
eode_proj(x, value0 = pp(list(X_A = 5, Y_A = 5, X_C = 3, Y_C = 2)), N = 100)
}
