% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/actions.R
\name{graph_action}
\alias{graph_action}
\alias{e_focus_adjacency}
\alias{e_unfocus_adjacency}
\title{Nodes Adjacency}
\usage{
e_focus_adjacency(e, ..., btn = NULL)

e_unfocus_adjacency(e, ..., btn = NULL)
}
\arguments{
\item{e}{An \code{echarts4r} object as returned by \code{\link{e_charts}} or
a proxy as returned by \code{\link{echarts4rProxy}}.}

\item{...}{Any options, see
\href{https://echarts.apache.org/en/api.html#action.graph}{official
documentation}}

\item{btn}{A \code{\link{e_button}} id.}
}
\description{
Actions related to \code{\link{e_graph}}.
}
\examples{
value <- rnorm(10, 10, 2)

nodes <- data.frame(
  name = sample(LETTERS, 10),
  value = value,
  size = value,
  grp = rep(c("grp1", "grp2"), 5),
  stringsAsFactors = FALSE
)

edges <- data.frame(
  source = sample(nodes$name, 20, replace = TRUE),
  target = sample(nodes$name, 20, replace = TRUE),
  stringsAsFactors = FALSE
)

e_charts() |>
  e_graph() |>
  e_graph_nodes(nodes, name, value, size, grp) |>
  e_graph_edges(edges, source, target) |>
  e_focus_adjacency(
    seriesIndex = 0,
    dataIndex = 4
  )
}
