% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/matrix.R
\name{e_scatter_matrix}
\alias{e_scatter_matrix}
\title{Generate scatter point for matrix}
\usage{
e_scatter_matrix(e, z, ...)
}
\arguments{
\item{e}{An \code{echarts4r} object as returned by \code{\link{e_charts}} or
a proxy as returned by \code{\link{echarts4rProxy}}.}

\item{z}{Column name for data to be used for scatter points}

\item{...}{Any other option to pass, check See Also section.}
}
\description{
Draw scatter points chart in matrix coordinate system
}
\examples{

df <- data.frame("Class" = rep(c("Class1", "Class2", "Class3"),each = 3),
                   "Grade" = c("Grade1","Grade2", "Grade3"),
                  "A" = sample(1:10, 9))

df |> e_chart() |>
 e_matrix(xAxis = "Class", yAxis = "Grade") |>
 e_matrix_parent(value = "Primary", children = c("Class1", "Class2")) |>
 e_matrix_parent(value = "High", children = "Class3") |>
 e_matrix_corner(value = "All School",
   label = list(fontSize = 24, color = "#555", position = "inside")) |>
 e_scatter(A, coord_system = "matrix", symbolSize = 0) |>
 e_labels(position = "inside",
          formatter = htmlwidgets::JS(
           'function(params){return(params.value[2]);}'),
          color = "#555",
          fontWeight = "bold")

df |> e_chart() |>
 e_matrix(xAxis = "Class", yAxis = "Grade") |>
 e_scatter_matrix("A") |>
 e_labels(position = "inside",
          formatter = htmlwidgets::JS('function(params){return(params.value[2]);}'),
          color = "#555",
          fontWeight = "bold") |>
 e_visual_map(A, inRange = list(symbolSize = c(1,50)))


}
\seealso{
\href{https://echarts.apache.org/en/option.html#series-scatter}{Additional arguments}
}
