% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tobit_sd.R
\name{tobit_sd}
\alias{tobit_sd}
\title{Fit Tobit Standard Deviation via Maximum Likelihood}
\usage{
tobit_sd(
  L,
  R,
  mu = matrix(colMeans(L + R)/2, nrow(L), ncol(L), byrow = TRUE),
  sd.structure = "global",
  interval = c(1e-04, 100),
  tol = .Machine$double.eps^0.25,
  maxiter = 1000
)
}
\arguments{
\item{L}{matrix of lower bounds on observations (n x p)}

\item{R}{matrix of upper bounds on observations (n x p)}

\item{mu}{matrix of known means (n x p)}

\item{sd.structure}{structure imposed on noise level estimates, must be one
of: "global", "column", "row", or "rank1"}

\item{interval}{a vector containing the end-points of the interval defining
the convex search space (default: \code{c(1e-4, 1e+2)})}

\item{tol}{the desired accuracy}

\item{maxiter}{early stopping condition}
}
\value{
matrix of maximum likelihood estimates for each observation's 
standard deviation (n x p)
}
\description{
Fit the matrix of standard deviations given censored observations current
mean estimates. Currently there are four models for S implemented: global,
column-specific, row-specific, and rank-1.
}
\examples{
set.seed(1)
n = 100; p = 5; r = 2
U.true = matrix(stats::rexp(n*r), n, r)
V.true = matrix(sample(x = c(1,4,7),
                       size = p*r, 
                       replace = TRUE, 
                       prob = c(0.7, 0.2, 0.1)), 
                p, r)
TH = tcrossprod(U.true, V.true)
X = TH + matrix(stats::rnorm(n*p, sd = 1), n, p)
ldl <- 0.1 # lower detection limit, known to be non-negative
L <- ifelse(X < ldl, 0, X)
R <- ifelse(X < ldl, ldl, X)

tobit_sd(L, R, mu = TH)
tobit_sd(L, R, mu = TH, sd.structure = "column")
}
